/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.common;

import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.search.common.IFilterMenu;
import dev.xkmc.l2artifacts.content.search.token.ArtifactChestToken;
import dev.xkmc.l2library.base.menu.base.BaseContainerMenu;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import dev.xkmc.l2library.base.menu.data.IntDataSlot;
import dev.xkmc.l2library.base.menu.scroller.ScrollerMenu;
import dev.xkmc.l2library.util.code.GenericItemStack;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractScrollerMenu<T extends AbstractScrollerMenu<T>>
extends BaseContainerMenu<T>
implements ScrollerMenu,
IFilterMenu {
    public final ArtifactChestToken token;
    public final IntDataSlot total_count;
    public final IntDataSlot current_count;
    public final IntDataSlot experience;
    public final DataSlot max_row;
    public final DataSlot row;
    protected final Player player;
    public final int extra;

    public AbstractScrollerMenu(MenuType<?> type, int wid, Inventory plInv, SpriteManager manager, int extra, ArtifactChestToken token, boolean isVirtual) {
        super(type, wid, plInv, manager, e -> new BaseContainerMenu.BaseContainer(36 + extra, (BaseContainerMenu)e), isVirtual);
        this.token = token;
        this.player = plInv.f_35978_;
        this.extra = extra;
        this.total_count = new IntDataSlot((AbstractContainerMenu)this);
        this.current_count = new IntDataSlot((AbstractContainerMenu)this);
        this.experience = new IntDataSlot((AbstractContainerMenu)this);
        this.max_row = this.m_38895_(DataSlot.m_39401_());
        this.row = this.m_38895_(DataSlot.m_39401_());
    }

    protected void reload(boolean changeContent) {
        if (this.player.m_9236_().m_5776_()) {
            return;
        }
        List<GenericItemStack<BaseArtifact>> list = this.token.getFiltered();
        this.max_row.m_6422_((int)Math.ceil((double)list.size() / 6.0));
        if (this.row.m_6501_() < 0) {
            this.row.m_6422_(0);
        }
        if (this.row.m_6501_() > this.getMaxScroll()) {
            this.row.m_6422_(this.getMaxScroll());
        }
        for (int i = 0; i < 36; ++i) {
            int index = this.row.m_6501_() * 6 + i;
            ItemStack stack = index >= list.size() ? ItemStack.f_41583_ : list.get(index).stack();
            this.container.m_6836_(i + this.extra, stack);
        }
        this.total_count.set(this.token.list.size());
        this.current_count.set(list.size());
        this.experience.set(this.token.exp);
    }

    public final int getMaxScroll() {
        return Math.max(0, this.max_row.m_6501_() - 6);
    }

    public final int getScroll() {
        return this.row.m_6501_();
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        int amount = pId / 100;
        if ((pId %= 100) == 0) {
            this.row.m_6422_(this.row.m_6501_() - amount);
            this.reload(false);
            return true;
        }
        if (pId == 1) {
            this.row.m_6422_(this.row.m_6501_() + amount);
            this.reload(false);
            return true;
        }
        pId -= 2;
        if ((pId += this.row.m_6501_() * 6) >= 0 && pId < this.current_count.get()) {
            if (!this.player.m_9236_().m_5776_()) {
                this.clickSlot(pId);
            }
            return true;
        }
        return super.m_6366_(pPlayer, pId);
    }

    protected abstract void clickSlot(int var1);

    public final boolean m_6875_(Player player) {
        return player.m_150109_().m_8020_(this.token.invSlot) == this.token.stack;
    }

    protected boolean shouldClear(Container container, int slot) {
        return slot < this.extra;
    }
}

